/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.Comparator;
import java.util.regex.Pattern;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VersionComparator
implements Comparator<Object> {
    public static final String DEFAULT_VERSION_DELIMITER = "-";
    private String m_delimiter = "-";

    public VersionComparator(String versionDelimiter) {
        this.m_delimiter = versionDelimiter;
    }

    @Override
    public int compare(Object versionString1, Object versionString2) {
        if (versionString1 == null && versionString2 == null) {
            return 0;
        }
        if (versionString1 == null) {
            return -1;
        }
        if (versionString2 == null) {
            return 1;
        }
        String str1 = versionString1.toString();
        String str2 = versionString2.toString();
        int status = 0;
        String[] str1Tokens = str1.split(Pattern.quote(this.m_delimiter));
        String[] str2Tokens = str2.split(Pattern.quote(this.m_delimiter));
        if (str1Tokens.length == 0 && str2Tokens.length == 0) {
            return 0;
        }
        for (int i = 0; i < str1Tokens.length; ++i) {
            if (str2Tokens.length <= i) {
                return 1;
            }
            status = this.compareAlpahnumeric(str1Tokens[i], str2Tokens[i]);
            if (status == 0) continue;
            return status;
        }
        if (str1Tokens.length == str2Tokens.length) {
            return 0;
        }
        return -1;
    }

    private int compareAlpahnumeric(String str1, String str2) {
        int str1_numSpan = this.getNumericSpan(str1);
        String str1_num = str1.substring(0, str1_numSpan);
        String str1_aph = str1.substring(str1_numSpan, str1.length());
        int str2_numSpan = this.getNumericSpan(str2);
        String str2_num = str2.substring(0, str2_numSpan);
        String str2_aph = str2.substring(str2_numSpan, str2.length());
        int status = this.compareNumeric(str1_num, str2_num);
        if (status == 0) {
            status = this.compareString(str1_aph, str2_aph);
        }
        return status;
    }

    private int compareNumeric(String str1_num, String str2_num) {
        String[] str2NumParts;
        int status = 0;
        String[] str1NumParts = str1_num.split(Pattern.quote("."));
        if (str1NumParts.length > (str2NumParts = str2_num.split(Pattern.quote("."))).length) {
            str2NumParts = this.getZeroPaddedString(str2_num, str1NumParts.length - str2NumParts.length).split(Pattern.quote("."));
        } else if (str1NumParts.length < str2NumParts.length) {
            str1NumParts = this.getZeroPaddedString(str1_num, str2NumParts.length - str1NumParts.length).split(Pattern.quote("."));
        }
        for (int i = 0; i < str1NumParts.length; ++i) {
            if (str2NumParts.length <= i) {
                return 1;
            }
            try {
                status = new Long(str1NumParts[i]).compareTo(new Long(str2NumParts[i]));
            }
            catch (NumberFormatException e) {
                status = str1NumParts[i].compareTo(str2NumParts[i]);
            }
            if (status == 0) continue;
            return status;
        }
        if (str1NumParts.length == str2NumParts.length) {
            return 0;
        }
        return -1;
    }

    private String getZeroPaddedString(String str, int count) {
        String result = str;
        for (int i = 0; i < count; ++i) {
            result = result + ".0";
        }
        return result;
    }

    private int compareString(String str1, String str2) {
        int status = 0;
        if (str1 != null || str2 != null) {
            status = str2 == null ? 1 : (str1 == null ? -1 : str1.compareTo(str2));
        }
        return status;
    }

    private int getNumericSpan(String str) {
        if (str == null) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== Num series span for null string is: 0");
            }
            return 0;
        }
        int i = 0;
        for (i = 0; i < str.length(); ++i) {
            Character ch = new Character(str.charAt(i));
            if (!Character.isDigit(str.charAt(i)) && 0 != ch.compareTo(new Character('.'))) break;
        }
        return i;
    }

    public static void main(String[] args) {
        VersionComparator comp = new VersionComparator(DEFAULT_VERSION_DELIMITER);
        System.out.println("comp.compare(11.2.0.3.0, 11.2.0.3) = " + comp.compare("11.2.0.3.0", "11.2.0.3"));
        System.out.println("comp.compare(11.2.0.3, 11.2.0.3.0) = " + comp.compare("11.2.0.3", "11.2.0.3.0"));
        System.out.println("comp.compare(null, null) = " + comp.compare((Object)null, (Object)null));
        System.out.println("comp.compare(null, foo) = " + comp.compare((Object)null, "foo"));
        System.out.println("comp.compare(foo, null) = " + comp.compare("foo", (Object)null));
        System.out.println("comp.compare(2.4.21-15.ELsmp, 2.4.21-15.11.1.ELsmp) = " + VerificationUtil.compareVersions("2.4.21-15.ELsmp", "2.4.21-15.11.1.ELsmp", DEFAULT_VERSION_DELIMITER));
        System.out.println("comp.compare(2.4.21-15.ELsmp, 2.4.21-15.11.1.ELsmp) = " + comp.compare("2.4.21-15.ELsmp", "2.4.21-15.11.1.ELsmp"));
        System.out.println("comp.compare(make-3.79.1-17, make-3.79) = " + comp.compare("make-3.79.1-17", "make-3.79"));
        System.out.println("comp.compare(binutils-2.11.90.0.8-12, binutils-2.14.90.0.4-35) = " + comp.compare("binutils-2.11.90.0.8-12", "binutils-2.14.90.0.4-35"));
        System.out.println("comp.compare(2.4.9-e.34enterprise, null) = " + comp.compare("2.4.9-e.34enterprise", "2.4.9-e.25"));
        System.out.println("comp.compare(jdk-1.4.2, jdk-5) = " + comp.compare("jdk-1.4.2", "jdk-5"));
    }
}

